//Source file: H:\src\Alkindi\Services\InternalData\UserEvalStats.java

/* Copyright (C) 2000-2001 Alkindi, Inc. */

package Alkindi.Services.InternalData;

import Alkindi.Data.SystemUser;

/**
 * Represents information about a user's evaluations and the number of Core and Selectable products. Returned by getUserUsed to calculate weights in RatingManager.getProductsToRate.
 */
public class UserEvalStats 
{
	
	/**
	 * The number of <b>Core</b> products shown to the user.
	 */
	public int coreShown = 0;
	
	/**
	 * The number of <b>Selectable</b> products shown to the user.
	 */
	public int selectableShown = 0;
	
	/**
	 * The total number of <b>Core</b> products.
	 */
	public int totalCore = 0;
	
	/**
	 * The total number of <b>Selectable</b> products.
	 */
	public int totalSelectable = 0;
	
	/**
	 * The ratio of the number of products the user rated, to the number of products shown to the user.
	 */
	public float epsilonUser;
	
	/**
	 * The ratio of the number of products rated to the number of products shown. This is with regard to all users.
	 */
	public float epsilonEveryone;
	
	/**
	 * The SystemUser for whom this evaulation information is assembled.
	 */
	public SystemUser user = null;
	
	/**
	 * Default Constructor.
	 * @roseuid 3AF823E80399
	 */
	public UserEvalStats() 
	{
	}
	
	/**
	 * Constructor which sets values for all members.
	 * @roseuid 3AF823E8039A
	 */
	public UserEvalStats(final SystemUser userIn, final int coreShownIn, final int selectableShownIn, final int totalCoreIn, final int totalSelectableIn, final float epsilonUserIn, final float epsilonEveryoneIn) 
	{
		user = userIn;
		coreShown = coreShownIn;
		selectableShown = selectableShownIn;
		totalCore = totalCoreIn;
		totalSelectable = totalSelectableIn;
		epsilonUser = epsilonUserIn;
		epsilonEveryone = epsilonEveryoneIn;
	}
	
	/**
	 * Returns a String representation of the internal data structure. Useful for debugging.
	 * @roseuid 3AF824550138
	 */
	public String toString() 
	{
		StringBuffer buf = new StringBuffer();
		buf.append("UserEvalStats for user ");
		buf.append(user.id);
		buf.append(": coreShown=");
		buf.append(coreShown);
		buf.append(" selectableShown=");
		buf.append(selectableShown);
		buf.append(" totalCore=");
		buf.append(totalCore);
		buf.append(" totalSelectable=");
		buf.append(totalSelectable);
		buf.append(" epsilonUser=");
		buf.append(epsilonUser);
		buf.append(" epsilonOverall=");
		buf.append(epsilonEveryone);
		buf.append("\n");
		return buf.toString();
	}
}
